﻿using System;
using System.Windows.Forms;
using RDR2;
using RDR2.UI;
using RDR2.Native;
using RDR2.Math;

namespace HCL_Superpower_03
{
    public class Main : Script
    {
        Player player = Game.Player;
        Ped playerPed = Game.Player.Character;
        float TKLength = 2.5f;
        bool Gun2Pressed = false;
        bool KeyPressed = false;
        bool CapturingEXP1 = false;
        bool CapturingEXP2 = false;
        int CapturingEXP1Num = 0;
        int CapturingEXP2Num = 0;
        int PressTimer = 0;
        Entity TKEntity = null;
        Entity RayEntity = null;

        public Main()
        {
            KeyDown += OnKeyDown;
            KeyUp += OnKeyUp;
            Tick += OnTick;
            Interval = 1;
        }

        private void OnTick(object sender, EventArgs e)
        {
            if (CapturingEXP1 && CapturingEXP1Num < 25)
            {
                  CapturingEXP1Num = CapturingEXP1Num + 1;
                  OutputArgument Vct = new OutputArgument();
                  bool Ishitting = Function.Call<bool>(Hash.GET_PED_LAST_WEAPON_IMPACT_COORD, playerPed, Vct);
                  if (Ishitting)
                  {
                            Vector3 Hitcoord = Vct.GetResult<Vector3>();
                            Function.Call(Hash.ADD_EXPLOSION, (Hitcoord.X), (Hitcoord.Y), (Hitcoord.Z), 32, 2.5f, true, false, 0);
                            Function.Call(Hash.ADD_EXPLOSION, (Hitcoord.X), (Hitcoord.Y), (Hitcoord.Z - 0.2f), 32, 1.5f, true, false, 0);
                            CapturingEXP1 = false;
                            CapturingEXP1Num = 0;
                  }
            }
            if (CapturingEXP2 && CapturingEXP2Num < 25)
            {
                  CapturingEXP2Num = CapturingEXP2Num + 1;
                  OutputArgument Vct = new OutputArgument();
                  bool Ishitting = Function.Call<bool>(Hash.GET_PED_LAST_WEAPON_IMPACT_COORD, playerPed, Vct);
                  if (Ishitting)
                  {
                            Vector3 Hitcoord = Vct.GetResult<Vector3>();
                            Function.Call(Hash.ADD_EXPLOSION, (Hitcoord.X), (Hitcoord.Y), (Hitcoord.Z - 0.5f), 32, 6.0f, true, false, 0);
                            Function.Call(Hash.ADD_EXPLOSION, (Hitcoord.X), (Hitcoord.Y), (Hitcoord.Z), 32, 4.5f, true, false, 0);
                            CapturingEXP2 = false;
                            CapturingEXP2Num = 0;
                  }
            }
            if (!KeyPressed && !Function.Call<bool>(Hash.IS_PLAYER_FREE_AIMING, player) && (Game.IsKeyPressed(Keys.D1) || Game.IsKeyPressed(Keys.D2) || Game.IsKeyPressed(Keys.D3) || Game.IsKeyPressed(Keys.D4)))
            {
                  Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.00375, 0.0075, 255, 255, 255, 255); 
                  Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.0025, 0.005, 0, 0, 0, 255); 
            }
            if (TKEntity == null && KeyPressed)
            {
                  Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.00375, 0.0075, 200, 200, 255, 255); 
                  Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.0025, 0.005, 0, 0, 55, 255); 
            }
            if (Gun2Pressed)
            {
                  if (PressTimer > 5)
                  {
                           PressTimer = 0;
                  }
                  if (PressTimer == 0)
                  {
                           Vector3 TargetSpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 1000f, RotToDir(NC_Get_Cam_Rotation()).Y * 1000f, RotToDir(NC_Get_Cam_Rotation()).Z * 1000f);
                           Vector3 TargetPosition = GameplayCamera.Position + TargetSpace;
                           World.ShootBullet(GameplayCamera.Position, TargetPosition, playerPed, 0x20D13FF, 100);
                  }
                  PressTimer = PressTimer + 1;
            }
            if (TKEntity != null)
            {
                     if (World.GetDistance(playerPed.Position, TKEntity.Position) > 200 || (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity) && TKEntity.IsDead))
                     {
                              if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                              {
                                      Function.Call(Hash.SET_PED_GRAVITY, TKEntity, true);
                                      Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, true);
                              }
                             else
                             {
                                      Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, true);
                             }
                             TKEntity = null;
                             TKLength = 2.5f;
                             RDR2.UI.Screen.ShowSubtitle("Telekinesis Off");
                     }
                     else
                     {
                             Function.Call(Hash.DRAW_RECT, 0.95, 0.35, 0.00375, 0.15, 200, 200, 255, 255); 
                             Function.Call(Hash.DRAW_RECT, 0.95, 0.35, 0.0025, (0.00075 * TKLength), 0, 0, 55, 255); 
                             Vector3 AAAA = new Vector3(GameplayCamera.Direction.X * TKLength, GameplayCamera.Direction.Y * TKLength, (GameplayCamera.Direction.Z * TKLength +1f));
                             Vector3 StarPosition = playerPed.Position + AAAA;
                             TKEntity.ApplyForce((StarPosition - TKEntity.Position) * 25f);  
                             Function.Call(Hash.SET_ENTITY_VELOCITY, TKEntity, 0, 0, 0);
                             if (Game.IsKeyPressed(Keys.D1) && TKLength < 200)
                             {
                                        TKLength = TKLength + 0.5f; 
                             }
                             if (Game.IsKeyPressed(Keys.D2))
                             {
                                        if (Function.Call<bool>(Hash.IS_ENTITY_A_VEHICLE, TKEntity))
                                        {
                                                if (TKLength > 3.5f)
                                                       TKLength = TKLength - 0.5f;
                                        }
                                        else
                                        {
                                                if (TKLength > 1.5f)
                                                       TKLength = TKLength - 0.5f;
                                        }
                             }
                     }
            }
        } 

        private void OnKeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.D1 && (e.Shift || (!e.Shift &&TKEntity == null)))
            {
                  Gun2Pressed = true;
            }
            if (e.KeyCode == Keys.Q && !e.Shift && TKEntity == null && !Function.Call<bool>(Hash.IS_PLAYER_FREE_AIMING, player))
            {
                     KeyPressed = true;
            }
        }

        private void OnKeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Q && !e.Shift)
            {
                    if (TKEntity != null)
                    {
                             if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                             {
                                      Function.Call(Hash.SET_PED_GRAVITY, TKEntity, true);
                                      Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, true);
                             }
                             else
                             {
                                      Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, true);
                             }
                             TKEntity = null;
                             TKLength = 2.5f;
                             RDR2.UI.Screen.ShowSubtitle("Telekinesis Off");
                    }
                    else
                    {
                              if (Function.Call<bool>(Hash.IS_PLAYER_FREE_AIMING, player))
                              {
                                         OutputArgument entTarget = new OutputArgument();
                                         bool IsAmining = Function.Call<bool>(Hash.GET_ENTITY_PLAYER_IS_FREE_AIMING_AT, player, entTarget);
                                         if (IsAmining)
                                         {
                                                 TKEntity = entTarget.GetResult<Entity>();
                                                 if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                                                 {
                                                        if (TKEntity.IsDead)
                                                        {
                                                                  TKEntity = null; 
                                                                  RDR2.UI.Screen.ShowSubtitle("You feel sick about moving a dead body.");
                                                        }
                                                        else
                                                        {
                                                                  TKEntity.Detach();
                                                                  TKLength = World.GetDistance(playerPed.Position, TKEntity.Position);  
                                                                  Function.Call(Hash.SET_PED_GRAVITY, TKEntity, false);
                                                                  RDR2.UI.Screen.ShowSubtitle("Telekinesis On");
                                                                  if (!Function.Call<bool>(Hash.IS_PED_HUMAN, TKEntity))
                                                                              Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, false);
                                                        }
                                                 }
                                                 else
                                                 {
                                                         TKEntity.Detach();
                                                         Vector3 EP1 = TKEntity.Position;
                                                         Function.Call(Hash.SET_ENTITY_VELOCITY, TKEntity, 0, 0, (2.0f));
                                                         Wait(50);      
                                                         Vector3 EP2 = TKEntity.Position; 
                                                         Function.Call(Hash.SET_ENTITY_VELOCITY, TKEntity, 0, 0, 0);
                                                         if (EP2 != EP1)
                                                         {
                                                                TKLength = World.GetDistance(playerPed.Position, TKEntity.Position);  
                                                                Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, false);
                                                                RDR2.UI.Screen.ShowSubtitle("Telekinesis On");
                                                         }
                                                         else
                                                         {
                                                                TKEntity = null;           
                                                                RDR2.UI.Screen.ShowSubtitle("You cannot move this object.");                                         
                                                         }  
                                                 }
                                         }
                              }
                              else
                              {
                                          if (RayEntity == null)
                                          {
                                                     Model PlayerModel = new Model(Function.Call<int>(Hash.GET_ENTITY_MODEL, playerPed));
	                                     Function.Call(Hash.REQUEST_MODEL, PlayerModel);
                                                     while (!Function.Call<bool>(Hash.HAS_MODEL_LOADED, PlayerModel))
                                                     {
                                                             Wait(1);
                                                     }
	                                     RayEntity = Function.Call<Ped>(Hash.CREATE_PED, PlayerModel, 0, 0, 0, 1.0, false, false);
                                                     Function.Call(Hash.SET_ENTITY_INVINCIBLE, RayEntity, true);
                                          }
                                          Vector3 RaySpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 100.0f, RotToDir(NC_Get_Cam_Rotation()).Y * 100.0f, RotToDir(NC_Get_Cam_Rotation()).Z * 100.0f);
                                          Vector3 TargetPosition = NC_Get_Cam_Position() + RaySpace;
                                          Function.Call(Hash.SET_ENTITY_VISIBLE, RayEntity, false);
                                          Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, RayEntity, false);
                                          Function.Call(Hash.SET_ENTITY_ROTATION, RayEntity, 0, 0, ((NC_Get_Cam_Rotation()).Z), 2, true); 
                                          Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, TargetPosition.X, TargetPosition.Y, (TargetPosition.Z), true, false, false, false);
                                          Wait(10);
                                          RaycastResult Raycast = World.Raycast(NC_Get_Cam_Position(), RayEntity.Position, IntersectOptions.Everything, playerPed);
                                          Wait(10);
                                          Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, 0, 0, 0, true, false, false, false);
                                          if (Raycast.DitHitEntity && Raycast.HitEntity != playerPed && Raycast.HitEntity != RayEntity) 
                                          {
                                                  TKEntity = Raycast.HitEntity;
                                                  if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                                                  {
                                                         if (TKEntity.IsDead)
                                                         {
                                                                   TKEntity = null; 
                                                                   RDR2.UI.Screen.ShowSubtitle("You feel sick about moving a dead body.");
                                                         }
                                                         else
                                                         {
                                                                   TKEntity.Detach();
                                                                   TKLength = World.GetDistance(playerPed.Position, TKEntity.Position);  
                                                                   Function.Call(Hash.SET_PED_GRAVITY, TKEntity, false);
                                                                   RDR2.UI.Screen.ShowSubtitle("Telekinesis On");
                                                                   if (!Function.Call<bool>(Hash.IS_PED_HUMAN, TKEntity))
                                                                            Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, false);
                                                         }
                                                  }
                                                  else
                                                  {
                                                          TKEntity.Detach();
                                                          Vector3 EP1 = TKEntity.Position;
                                                          Function.Call(Hash.SET_ENTITY_VELOCITY, TKEntity, 0, 0, (2.0f));
                                                          Wait(50);      
                                                          Vector3 EP2 = TKEntity.Position; 
                                                          Function.Call(Hash.SET_ENTITY_VELOCITY, TKEntity, 0, 0, 0);
                                                          if (EP2 != EP1)
                                                          {
                                                                 TKLength = World.GetDistance(playerPed.Position, TKEntity.Position);  
                                                                 Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, false);
                                                                 RDR2.UI.Screen.ShowSubtitle("Telekinesis On");
                                                          }
                                                          else
                                                          {
                                                                 TKEntity = null;           
                                                                 RDR2.UI.Screen.ShowSubtitle("You cannot move this object.");                                         
                                                          }  
                                                  }
                                          }
                              }
                    }
            }
            if (e.KeyCode == Keys.Q)
            {
                     KeyPressed = false;
            }
            if (e.KeyCode == Keys.D1)
            {
                     Gun2Pressed = false;
                     PressTimer = 0;
            }
            if (e.KeyCode == Keys.D2 && (e.Shift || (!e.Shift &&TKEntity == null)))
            {
                             Vector3 TargetSpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 1000f, RotToDir(NC_Get_Cam_Rotation()).Y * 1000f, RotToDir(NC_Get_Cam_Rotation()).Z * 1000f);
                             Vector3 TargetPosition = GameplayCamera.Position + TargetSpace;
                             World.ShootBullet(GameplayCamera.Position, TargetPosition, playerPed, 0xE1D2B317, 100);
            }
            if (e.KeyCode == Keys.D3 && (e.Shift || (!e.Shift &&TKEntity == null)))
            {
                  Vector3 TargetSpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 1000f, RotToDir(NC_Get_Cam_Rotation()).Y * 1000f, RotToDir(NC_Get_Cam_Rotation()).Z * 1000f);
                  Vector3 TargetPosition = GameplayCamera.Position + TargetSpace;
                  CapturingEXP1 = true;
                  CapturingEXP1Num = 0;
                  World.ShootBullet(GameplayCamera.Position, TargetPosition, playerPed, 0xE1D2B317, 50);
            }
            if (e.KeyCode == Keys.D4 && (e.Shift || (!e.Shift &&TKEntity == null)))
            {
                  Vector3 TargetSpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 1000f, RotToDir(NC_Get_Cam_Rotation()).Y * 1000f, RotToDir(NC_Get_Cam_Rotation()).Z * 1000f);
                  Vector3 TargetPosition = GameplayCamera.Position + TargetSpace;
                  CapturingEXP2 = true;
                  CapturingEXP2Num = 0;
                  World.ShootBullet(GameplayCamera.Position, TargetPosition, playerPed, 0xE1D2B317, 50);
            }
            if (e.KeyCode == Keys.D3 && !e.Shift && TKEntity != null)
            {
                             Vector3 TKPosition = playerPed.Position + new Vector3(0, 0, 0.5f);
                             TKEntity.ApplyForce((TKEntity.Position - TKPosition) * 100f / (TKEntity.Position - TKPosition).Length()); 
                             if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                             {
                                      Function.Call(Hash.SET_PED_GRAVITY, TKEntity, true);
                                      Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, true);
                                      if (Function.Call<bool>(Hash.IS_PED_HUMAN, TKEntity) && !Function.Call<bool>(Hash.IS_PED_RAGDOLL, TKEntity))
                                                  Function.Call(Hash.SET_PED_TO_RAGDOLL, TKEntity, 10, 10, 1, true, true, true);
                             }
                             else
                             {
                                      Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, true);
                             }
                             TKEntity = null;
                             TKLength = 2.5f;
                             RDR2.UI.Screen.ShowSubtitle("Telekinesis Off");
            }
            if (e.KeyCode == Keys.D4 && !e.Shift && TKEntity != null)
            {
                     Function.Call(Hash.ADD_EXPLOSION, (TKEntity.Position.X), (TKEntity.Position.Y), (TKEntity.Position.Z), 23, 1.0f, true, false, 0);
                     if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                     {
                              Function.Call(Hash.SET_PED_GRAVITY, TKEntity, true);
                              Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, true);
                              if (Function.Call<bool>(Hash.IS_PED_HUMAN, TKEntity) && !Function.Call<bool>(Hash.IS_PED_RAGDOLL, TKEntity))
                                          Function.Call(Hash.SET_PED_TO_RAGDOLL, TKEntity, 10, 10, 1, true, true, true);
                     }
                     else
                     {
                              Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, true);
                     }
                     TKEntity = null;
                     TKLength = 2.5f;
                     RDR2.UI.Screen.ShowSubtitle("Telekinesis Off");
            }
        }

        public Vector3 RotToDir(Vector3 Rot)
        {
            try
            {
                float z = Rot.Z;
                float retz = z * 0.0174532924F;
                float x = Rot.X;
                float retx = x * 0.0174532924F;
                float absx = (float)System.Math.Abs(System.Math.Cos(retx));
                return new Vector3((float)-System.Math.Sin(retz) * absx, (float)System.Math.Cos(retz) * absx, (float)System.Math.Sin(retx));
            }
            catch
            {
                return new Vector3(0, 0, 0);
            }
        }

        public Vector3 NC_Get_Cam_Position()
        {
            try
            {
                return Function.Call<Vector3>(Hash.GET_GAMEPLAY_CAM_COORD);
            }
            catch
            {

            }
            return new Vector3(0, 0, 0);
        }

        public Vector3 NC_Get_Cam_Rotation()
        {
            try
            {
                return Function.Call<Vector3>(Hash.GET_GAMEPLAY_CAM_ROT, 0);
            }
            catch
            {

            }
            return new Vector3(0, 0, 0);
        } 
    }
}
